

#' Sparse Estimation of a Covariance Matrix
#' 
#' Performs the majorize-minimize algorithm described in
#' 
#' Bien, J., and Tibshirani, R. (2011), "Sparse Estimation of a Covariance
#' Matrix," Biometrika. 98(4). 807--820.
#' 
#' Generalized gradient descent is used to minimize each majorizer.
#' 
#' \tabular{ll}{ Package: \tab spcov\cr Type: \tab Package\cr Version: \tab
#' 1.01\cr Date: \tab 2012-03-04\cr License: \tab GPL-2\cr LazyLoad: \tab
#' yes\cr } See the function \code{spcov}.
#' 
#' @name spcov-package
#' @docType package
#' @author Jacob Bien and Rob Tibshirani
#' 
#' Maintainer: Jacob Bien <jbien@@stanford.edu>
#' @seealso \code{\link{spcov}}
#' @references Bien, J., and Tibshirani, R. (2011), "Sparse Estimation of a
#' Covariance Matrix," Biometrika. 98(4). 807--820.
#' @keywords multivariate
NULL



