% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeComposite.R
\name{makeComposite}
\alias{makeComposite}
\title{Create a labeled image grid}
\usage{
makeComposite(
  folder = ".",
  custom_order,
  rows,
  cols,
  spacing = 15,
  resize_mode = c("none", "fit", "fill", "width", "height", "both"),
  labels = list(),
  label_settings = list(),
  background_color = "white",
  desired_width = 15,
  width_unit = "cm",
  ppi = 300,
  output_format = "tiff",
  output_folder = NULL
)
}
\arguments{
\item{folder}{Character. Path to the folder containing images. Default is working directory (`"."`).}

\item{custom_order}{Character vector. Set of filenames (use NA for blank slots).}

\item{rows}{Integer. Number of rows in the grid.}

\item{cols}{Integer. Number of columns in the grid.}

\item{spacing}{Integer. Spacing (in pixels) between tiles. Default is `15`}

\item{resize_mode}{Character. One of "none", "fit", "fill", "width", "height", "both";
- "none": keep each panel at original size
- "fit": scale each panel to fit within the smallest image dimensions (preserving aspect ratio)
- "fill": scale and crop each panel to exactly fill the smallest dimensions
- "width": resize to minimum width, keep original height
- "height": resize to minimum height, keep original width
- "both": force exact width and height (may distort aspect ratio).}

\item{labels}{List of up to 4 character vectors. Each vector corresponds to one label layer and must be the same length as the number of non-NA images. Use empty strings "" or NULL entries to omit specific labels.}

\item{label_settings}{List of named lists. Each named list specifies settings for a label layer;
- size: font size (e.g., 100)
- color: font color
- font: font family (e.g., "Arial")
- boxcolor: background color behind text (or NA for none)
- location: offset from gravity anchor (e.g., "+10+10")
- gravity: placement anchor (e.g., "northwest")
- weight: font weight (e.g., 400 = normal, 700 = bold).}

\item{background_color}{Character. Background color used for blank tiles and borders. Use `"none"` for transparency. Default is `"white"`.}

\item{desired_width}{Numeric. Desired width of final image (in cm or px). Default is `15`}

\item{width_unit}{Character. Either "cm" or "px". Default is `"cm"`}

\item{ppi}{Numeric. Resolution (pixels per inch) for output file. Default is `300`}

\item{output_format}{Character. File format for saving plots. Examples: `"tiff"`, `"png"`, `"pdf"`. Default is `"tiff"`.}

\item{output_folder}{Character. Path to folder where image is saved. If NULL (default), image is not saved; if `"."`, image is saved in the working directory.}
}
\value{
Saves image composite to a specified output folder. Returns `NULL` (used for side-effects).
}
\description{
Generates a composite image grid with customizable layout, labels and resizing options. Suitable for spectra and other image types.
}
\examples{
library(magick)

tmp_dir <- file.path(tempdir(), "spectrakit_imgs")
dir.create(tmp_dir, showWarnings = FALSE)

# Create and save img1
img1 <- image_blank(100, 100, "white")
img1 <- image_draw(img1)
symbols(50, 50, circles = 30, inches = FALSE, add = TRUE, bg = "red")
dev.off()
img1_path <- file.path(tmp_dir, "img1.png")
image_write(img1, img1_path)

# Create and save img2
img2 <- image_blank(100, 100, "white")
img2 <- image_draw(img2)
rect(20, 20, 80, 80, col = "blue", border = NA)
dev.off()
img2_path <- file.path(tmp_dir, "img2.png")
image_write(img2, img2_path)

# Create composite
makeComposite(
        folder = tmp_dir,
        custom_order = c("img1.png", "img2.png"),
        rows = 1,
        cols = 2,
        labels = list(c("Red Circle", "Blue Rectangle")),
        label_settings = list(
                list(size = 5, font = "Arial", color = "black", boxcolor = "white",
                     gravity = "northwest", location = "+10+10", weight = 400)
        ),
        resize_mode = "none",
        desired_width = 10,
        width_unit = "cm",
        ppi = 300,
        output_format = "png",
        output_folder = tmp_dir
)

}
