% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/violin.plot.R
\name{violin.plot}
\alias{violin.plot}
\title{Create violin plots of reflectance per band for each surface class}
\usage{
violin.plot(data)
}
\arguments{
\item{data}{reflectance data as dataframe with pixel values for Sentinel optical bands
B2, B3, B4, B5, B6, B7, B8, B8A, B11, B12}
}
\value{
ggplot2 object with basic visual aesthetics. Default aesthetics is
violin plot for each satellite band (geom_violin).
See https://ggplot2.tidyverse.org/reference/geom_violin.html for more details.
}
\description{
Create violin plots of reflectance per band for each surface class
}
\examples{
# Load example data
load(system.file("testdata/reflectance_test_data.RData", package = "spectralR"))

# Create a plot
p3 <- violin.plot(data = reflectance)

# Customize a plot
p3 +
  ggplot2::labs(x='Surface class',y='Reflectance',
      fill="Surface classes",
      title = "Reflectance for different surface classes",
      caption='Data: Sentinel-2 Level-2A')+
  ggplot2::theme_minimal()

}
