% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_function_overloads.R
\name{sd.default}
\alias{sd.default}
\title{Default standard deviation}
\usage{
\method{sd}{default}(x, na.rm = FALSE)
}
\arguments{
\item{x}{a numeric vector or an R object which is coercible to one by as.double(x)}

\item{na.rm}{logical. Should missing values be removed?}
}
\value{
standard deviation of x
}
\description{
\code{sd} computes the standard deviation of the values in x. If na.rm is TRUE then missing values are removed before computation proceeds.
}
\examples{
x = rnorm(n = 200, mean = 0, sd = 1)
sd(x)

}
