% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spell_functions.R
\name{correct}
\alias{correct}
\title{Correct a Single Misspelled Word}
\usage{
correct(word, sorted_words, ignore_punct = FALSE, threshold = 0.12)
}
\arguments{
\item{word}{A character string representing the misspelled word}

\item{sorted_words}{A character vector of correctly spelled words sorted
by frequency}

\item{ignore_punct}{Logical. If TRUE, ignores punctuation when calculating
string distance}

\item{threshold}{Numeric. Maximum string distance threshold for considering
a word as a correction candidate}
}
\value{
A character string with the corrected word
}
\description{
Finds the best correction for a single misspelled word using string distance
and frequency-based ranking from a sorted word list.
}
