% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.BVCfit.R
\name{predict.BVCfit}
\alias{predict.BVCfit}
\alias{predict.VarLin}
\alias{predict.VarOnly}
\alias{predict.LinOnly}
\title{make predictions from a BVCfit object}
\usage{
\method{predict}{BVCfit}(object, X.new, Z.new, E.new = NULL, clin.new = NULL, Y.new = NULL, ...)

\method{predict}{VarLin}(object, X.new, Z.new, E.new, clin.new = NULL, Y.new = NULL, ...)

\method{predict}{VarOnly}(object, X.new, Z.new, clin.new = NULL, Y.new = NULL, ...)

\method{predict}{LinOnly}(object, X.new, Z.new, E.new = NULL, clin.new = NULL, Y.new = NULL, ...)
}
\arguments{
\item{object}{BVCfit object.}

\item{X.new}{a matrix of new values for X at which predictions are to be made.}

\item{Z.new}{a vector of new values for Z at which predictions are to be made.}

\item{E.new}{a vector of new values for E at which predictions are to be made.}

\item{clin.new}{a vector or matrix of new values for clin at which predictions are to be made.}

\item{Y.new}{a vector of the response of new observations. If provided, the prediction mean squared error (PMSE) will be computed based on Y.new.}

\item{...}{other predict arguments}
}
\value{
an object of class "BVCfit.pred" is returned, which is a list with components:
\item{pmse}{predictions mean squared error. pmse is NULL is Y.new=NULL.}
\item{y.pred}{predicted values of the new observations.}
}
\description{
make predictions from a BVCfit object
}
\details{
X.new (clin.new) must have the same number of columns as X (clin) used for fitting the model. If E and clin are provided when fit the model, E.new and clin.new
must not be NULL, and vice versa. The predictions are made based on the posterior estimates of coefficients in the BVCfit object.
Note that the main effects of environmental exposures Z and E are not subject to selection.
}
\examples{
data(gExp)
spbayes=BVCfit(X, Y, Z, E, clin)
spbayes

data(gExp.new)
pred = predict(spbayes, X.new, Z.new, E.new, clin.new, Y.new)
pred$pmse
# pred$y.pred

}
\seealso{
\code{\link{BVCfit}}
}
