% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{ide}
\alias{ide}
\title{Intrinsic dimension estimation (ide).}
\usage{
ide(data, inc_slow = FALSE)
}
\arguments{
\item{data}{A matrix or data frame containing the data to be analyzed.}

\item{inc_slow}{A logical value indicating whether to include the more
computationally expensive methods in the estimation. If \code{TRUE}, add 6
more expensive methods. Defaults to \code{FALSE}.}
}
\value{
A named vector of estimated intrinsic dimensions. The names correspond
to the \code{Rdimtools} function used for each estimate. \code{NA} is returned for
any method that fails to run.
}
\description{
This function estimates the intrinsic dimension of a dataset using several
algorithms from the \code{Rdimtools} package. This is used to inform the number of
dimension that should be kept when embedding data.
}
\examples{
# Use a tourr dataset with the default (fast) methods
dat <- spinifex::weather_na.rm[, 2:18]
(result <- ide(data = dat, inc_slow = FALSE))

# The result is a named vector, which can be summarized
summary(result)
# This suggests 6 or so dimensions may be sufficient embedding
# to describe the original 17 variables.

# Or visualized
hist(result)

# Note: Including 'inc_slow = TRUE' can take considerably longer
# to run for larger datasets.
\dontrun{
# Run all methods, including the slower ones, on a larger dataset
system.time(ide_long <- ide(dat, inc_slow = TRUE))
}

}
