% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{spiral_segments}
\alias{spiral_segments}
\title{Add segments to a track}
\usage{
spiral_segments(
  x0,
  y0,
  x1,
  y1,
  gp = gpar(),
  arrow = NULL,
  track_index = current_track_index()
)
}
\arguments{
\item{x0}{X-locations of the start points of the segments.}

\item{y0}{Y-locations of the start points of the segments.}

\item{x1}{X-locations of the end points of the segments.}

\item{y1}{Y-locations of the end points of the segments.}

\item{gp}{Graphical parameters.}

\item{arrow}{A \code{\link[grid:arrow]{grid::arrow()}} object.}

\item{track_index}{Index of the track.}
}
\value{
No value is returned.
}
\description{
Add segments to a track
}
\examples{
n = 1000
x0 = runif(n)
y0 = runif(n)
x1 = x0 + runif(n, min = -0.01, max = 0.01)
y1 = 1 - y0

spiral_initialize(xlim = range(c(x0, x1)))
spiral_track()
spiral_segments(x0, y0, x1, y1, gp = gpar(col = circlize::rand_color(n)))

n = 100
x0 = runif(n)
y0 = runif(n)
x1 = x0 + runif(n, min = -0.01, max = 0.01)
y1 = 1 - y0

spiral_initialize(xlim = range(c(x0, x1)))
spiral_track()
col = circlize::rand_color(n, luminosity = "bright")
spiral_segments(x0, y0, x1, y1, 
    arrow = arrow(length = unit(2, "mm")), gp = gpar(col = col))

# if the segments are short and you want the straight "real" segments
spiral_initialize(xlim = range(c(x0, x1)))
spiral_track()
df0 = xy_to_cartesian(x0, y0)
df1 = xy_to_cartesian(x1, y1)
grid.segments(df0$x, df0$y, df1$x, df1$y, default.units = "native", 
    arrow = arrow(length = unit(2, "mm")), gp = gpar(col = col))
}
