% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-volleyball.R
\name{geom_volleyball}
\alias{geom_volleyball}
\title{Draw Volleyball Court}
\usage{
geom_volleyball(
  league,
  display_range = "full",
  court_updates = list(),
  color_updates = list(),
  rotation = 0,
  x_trans = 0,
  y_trans = 0,
  court_units = NULL,
  xlims = NULL,
  ylims = NULL
)
}
\arguments{
\item{league}{The league for which to draw the surface. This is
case-insensitive}

\item{display_range}{A case-insensitive string indicating the display range
to use for the plot. The default is \code{"full"}, which will be returned
when either an invalid or no value is passed to the function.

The possible display ranges are:
\describe{
\item{\code{"full"}}{
The full court. This is the default
}
\item{\code{"in_bounds_only"}}{The full in-bounds area of the court}
\item{\code{"in bounds only"}}{The full in-bounds area of the court}
\item{\code{"offense"}}{
The offensive half of the court. This is the right half of the court
in TV view
}
\item{\code{"offence"}}{
The offensive half of the court. This is the right half of the court
in TV view
}
\item{\code{"offensivehalfcourt"}}{
The offensive half of the court. This is the right half of the court
in TV view
}
\item{\code{"offensive_half_court"}}{
The offensive half of the court. This is the right half of the court
in TV view
}
\item{\code{"offensive half court"}}{
The offensive half of the court. This is the right half of the court
in TV view
}
\item{\code{"defense"}}{
The defensive half of the court. This is the left half of the court in
TV view
}
\item{\code{"defence"}}{
The defensive half of the court. This is the left half of the court in
TV view
}
\item{\code{"defensivehalfcourt"}}{
The defensive half of the court. This is the left half of the court in
TV view
}
\item{\code{"defensive_half_court"}}{
The defensive half of the court. This is the left half of the court in
TV view
}
\item{\code{"defensive half court"}}{
The defensive half of the court. This is the left half of the court in
TV view
}
}}

\item{court_updates}{A list of updates to the courts' parameters. These will
overwrite the parameters of the league}

\item{color_updates}{A list of updates to the courts' default colors, which
are set by \code{\link[=volleyball_features_set_colors]{volleyball_features_set_colors()}}}

\item{rotation}{An angle, given in degrees, through which the plot should be
rotated}

\item{x_trans}{The amount that the \code{x} coordinates are to be shifted. By
convention, the +\code{x} axis extends from the center of the court towards
the right-hand basket when viewing the court in TV View}

\item{y_trans}{The amount that the \code{y} coordinates are to be shifted. By
convention, the +\code{y} axis extends from the center of the court towards
the top of the court when viewing the court in TV view}

\item{court_units}{The units with which to draw the court. The default is
\code{NULL}, which will apply the rule-book specified units}

\item{xlims}{The limits on the final display in the \code{x} direction. The
default is \code{NULL}, which will utilize the \code{xlims} specified by
the \code{display_range} parameter}

\item{ylims}{The limits on the final display in the \code{y} direction. The
default is \code{NULL}, which will utilize the \code{ylims} specified by
the \code{display_range} parameter}
}
\value{
A \code{ggplot2} instance with a full-surface representation of a
volleyball court
}
\description{
Generate a \code{ggplot2} instance containing a volleyball court for a
specified league
}
\examples{
\dontrun{
  geom_volleyball(league = "NCAA", rotation = 270, display_range = "offense")
  geom_volleyball(league = "FIVB", court_units = "ft")
}
}
