% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpfits.R
\name{bppo}
\alias{bppo}
\title{Bernstein Polynomial Based Proportional Odds Model}
\usage{
bppo(formula, degree, data, approach = c("mle", "bayes"), ...)
}
\arguments{
\item{formula}{a Surv object with time-to-event observations, right censoring status and explanatory terms.}

\item{degree}{Bernstein polynomial degree.}

\item{data}{a data.frame object.}

\item{approach}{Bayesian or maximum likelihood estimation methods, default is approach = "mle".}

\item{...}{further arguments passed to or from other methods}
}
\value{
An object of class `spbp`.
}
\description{
Fits the BPPO model to time-to-event data.
}
\examples{

library("spsurv")
data("veteran")

fit <- bppo(Surv(time, status) ~ karno + celltype,
data = veteran)

summary(fit)

}
\seealso{
\code{\link[spsurv]{spbp}}, \code{\link[spsurv]{bpph}} and \code{\link[spsurv]{bpaft}} for other BP based models.
}
