#' VALUES statement.
#'
#' This class represents a SQL VALUES statement, used when inserting multiple
#' rows.
#'
#' @examples
#' # Create a VALUES statement with two rows:
#' row1 <- ExprListValues$new(list(ExprValue$new("abc"), ExprValue$new(123)))
#' row2 <- ExprListValues$new(list(ExprValue$new("def"), ExprValue$new(456)))
#' values <- StmtValues$new(list(row1, row2))
#'
#' @import R6
#' @include Statement.R
#' @export
StmtValues <- R6::R6Class("StmtValues",
  inherit = Statement,
  public = list(

    #' @description
    #' Initializer.
    #' @param values An instance of ExprListValues
    #' @return Nothing.
    initialize = function(values) {
      chk::chk_all(values, chk::chk_is, "ExprListValues")
      private$values <- values
    },

    #' @description
    #' Generates the list of tokens representing this statement.
    #' @return A list of Token objects.
    getTokens = function() {
      tokens <- list(.values, .spc)
      i <- 0L
      for (v in private$values) {
        if (i > 0L) {
          tokens <- c(tokens, .coma, optspace())
        }
        tokens <- c(tokens, v$getTokens())
        i <- i + 1L
      }
      return(tokens)
    }
  ),
  private = list(
    values = NULL
  )
)
