% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QueryInsert.R
\name{QueryInsert}
\alias{QueryInsert}
\title{Insert query.}
\description{
Insert query.

Insert query.
}
\details{
This class represents an SQL SELECT query.
See the make_insert() factory function to create more easily an INSERT query
object.
}
\examples{
# To generate a simple INSERT query:
fields <- c('author', 'title', 'year')
insert <- StmtInsert$new(tabl = 'books', fields = make_fields(fields))
values <- make_rows(list(list('John Smith', 'Memories', 1999),
                         list('Barbara', 'My Life', 2010)))
insert <- QueryInsert$new(insert = insert, values = values)

}
\seealso{
\code{\link{make_insert}}
}
\section{Super class}{
\code{\link[sqlq:Query]{sqlq::Query}} -> \code{QueryInsert}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-QueryInsert-new}{\code{QueryInsert$new()}}
\item \href{#method-QueryInsert-clone}{\code{QueryInsert$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="sqlq" data-topic="Query" data-id="add"><a href='../../sqlq/html/Query.html#method-Query-add'><code>sqlq::Query$add()</code></a></span></li>
<li><span class="pkg-link" data-pkg="sqlq" data-topic="Query" data-id="toString"><a href='../../sqlq/html/Query.html#method-Query-toString'><code>sqlq::Query$toString()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueryInsert-new"></a>}}
\if{latex}{\out{\hypertarget{method-QueryInsert-new}{}}}
\subsection{Method \code{new()}}{
Initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryInsert$new(insert, values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{insert}}{A StmtInsert instance.}

\item{\code{values}}{A StmtValues instance.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueryInsert-clone"></a>}}
\if{latex}{\out{\hypertarget{method-QueryInsert-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryInsert$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
