testthat::context("Delete Query class")

testthat::test_that("We can create an DELETE query with the contructor", {
  where <- StmtWhere$new(ExprBinOp$new(
    ExprField$new("year"), "<",
    ExprValue$new(2015)
  ))
  x <- QueryDelete$new(StmtDelete$new('books'))
  x$add(where)
  testthat::expect_equal(x$toString(), 'DELETE FROM books WHERE "year" < 2015;')
})

testthat::test_that("We can create an DELETE query using the factory", {
  where <- StmtWhere$new(ExprBinOp$new(
    ExprField$new("year"), "<",
    ExprValue$new(2015)
  ))
  x <- make_delete(tabl = 'books', where = where)
  testthat::expect_equal(x$toString(), 'DELETE FROM books WHERE "year" < 2015;')
})
