\name{sraMinuslogL}
\alias{sraMinuslogL}
\alias{sraMinuslogL.log}
\alias{sraAutoregTsMinuslogL}
\alias{sraAutoregTsMinuslogL.log}
\title{ Calculation of the likelihood of time series (internal functions) }
\description{
  These functions are used internally by the sra package to compute the likelihood of the dataset given a specific model.
}
\usage{
sraMinuslogL(sradata, FUNtimeseries = sraAutoregTimeseries, 
	Bulmer=TRUE, logvarME=log(1e-20), ...)
sraMinuslogL.log(sradata.log, FUNtimeseries = sraAutoregTimeseries, 
	Bulmer=TRUE, logvarME=log(1e-20), ...)
sraAutoregTsMinuslogL(data.mean, data.var, data.N, 
	theor.mean, theor.var, logvarME=log(1e-20))
sraAutoregTsMinuslogL.log(data.mean, data.var, data.N, 
	theor.mean, theor.var, logvarME=log(1e-20))
}

\arguments{
  \item{sradata}{ A data object generated by \code{\link{sraData}}. }
  \item{sradata.log}{ A data object generated by \code{\link{sraData}} after log transformation. }
  \item{FUNtimeseries}{ The corresponding function to compute the expected time series (one of those listed in \code{\link{sraAutoregTimeseries}}. }
  \item{Bulmer}{ Whether or not the impact of linkage disequilibrium (Bulmer effect) due to selection on variance should be accounted for. }
  \item{logvarME}{ (log)-macroenvironmental variance, which is not included in the models themself (no impact on the expected time series), but can be estimated through its effect on the residual variance.}
  \item{\dots}{ The parameters of the model. }
  \item{data.mean}{ The vector of the mean phenotypes, from the data. }
  \item{data.var}{ The vector of the phenotypic variances, from the data. }
  \item{data.N}{ The vector of the population sizes, from the data. }
  \item{theor.mean}{ The vector of the theoretical mean phenotypes, from the model. }
  \item{theor.var}{ The vector of the theoretical phenotypic variances, from the model. }
}

\value{
  \code{sraAutoregTsMinuslogL} returns the minus log likelihood of a single time series (e.g. one selection line). \code{sraMinuslogL}
returns the minus log likelihood of the whole dataset, including all repetitions. The ".log" version of these functions compute the likelihood when sradata has been log-transformed. 
}
\references{ Le Rouzic, A., Houle, D., and Hansen, T.F. (2011) A modelling framework for the analysis of artificial selection-response time series. Genetics Research. }

\note{ These functions are not designed to be called by the end user. }
\seealso{ \code{\link{sraAutoreg}}, \code{\link{sraCstvar}}, and all other mechanistic models, \code{\link{sraAutoregTimeseries}}. }


\keyword{ models }
\keyword{ internal }
