% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_lcomp.R
\name{sample_lcomp}
\alias{sample_lcomp}
\title{Sample length compositions from a Stock Synthesis data file}
\usage{
sample_lcomp(dat_list, outfile, fleets, Nsamp, years, cpar = 1,
  ESS = NULL)
}
\arguments{
\item{dat_list}{An SS data list object as read in from
\code{\link[r4ss]{SS_readdat}} in the \pkg{r4ss} package. Make sure
you select option \code{section=2}.}

\item{outfile}{A character string specifying the file name to use
when writing the information to the disk. The string must include
the proper file extension. No file is written using the default value
of \code{NULL}, which leads to increased speed because writing the 
file takes time and computing resources.}

\item{fleets}{*A vector of integers specifying which fleets to include.
The order of the fleets pertains to the input order of other arguments.
An entry of \code{fleets=NULL} leads to zero samples for any fleet.}

\item{Nsamp}{*A numeric list of the same length as \code{fleets}.
Either single values or vectors of the same length as the number of
years can be passed through. Single values are repeated for all
years. If no fleet collected samples, keep the value to
\code{Nsamp=NULL}.}

\item{years}{*A list the same length as \code{fleets} giving the years as
numeric vectors. If no fleet collected samples, keep the value to
\code{years=NULL}.}

\item{cpar}{A numeric value or vector the same length as
\code{fleets} controlling the variance of the Dirichlet
distribution used for sampling. A value of \code{1} leads to the
same standard deviation as a multinomial of the given \code{Nsamp},
\code{2} indicates twice, etc. Values greater than one indicate
overdispersion, and less underdispersion. \code{NULL} or \code{NA}
for a given fleet will lead to no dispersion.}

\item{ESS}{The final effective sample size (ESS) associated with the
simulated data. The ESS is not used to generate the simulated data
but can be used as an input sample size in subsequent models that estimate
population parameters or status.
The default, \code{NULL}, leads to the true (internally calculated)
#' ESS being used, which is \code{Nsamp} for the multinomial case or given
by the formula under \code{cpar} for the Dirichlet case.
At least one value must be provided for each fleet or a vector of
year-specific values can be used for any given fleet.
The argument accepts a list with entries,
either a single integer or a vector of integers, for each fleet.}
}
\value{
A modified \code{.dat} file if \code{!is.null(outfile)}. A list object
containing the modified \code{.dat} file is returned invisibly.
}
\description{
Extract length-composition data from a \code{.ss_new} data file and sample
the data. It is assumed that the composition data will be expected values
as written by Stock Synthesis in the second section of the data file, but 
one can also sample input data. The resulting length-composition
data are assumed to represent observed length composition and will overwrite
the length data in \code{dat_list}, which is returned invisibly. 
The data file can also be written to the disk, if a file path is provided to
\code{outfile}, and used as simulated data by an estimation model.
If used with \code{\link{run_ss3sim}}, the case file should be named
\code{agecomp}. A suggested (default) case letter is \code{D} for data.
}
\section{Which arguments to specifiy in case files}{

All function argument descriptions that start with an asterisk (*) will be passed
through the case files to \code{\link{run_ss3sim}}. If one of these arguments
is not specified in a case file, then a value of \code{NULL} will be passed,
which may or may not be an appropriate value. Other arguments will be ignored
if specified.
}

\examples{
dat_list <- r4ss::SS_readdat(verbose = FALSE,
  file = system.file(file.path("extdata", "models", "cod-om", "codOM.dat"), 
  package="ss3sim"))
## Generate with constant sample size across years
ex1 <- sample_lcomp(dat_list=dat_list, outfile = NULL, 
  fleets = 1:2, Nsamp = list(100, 50), 
  years=list(seq(26, 100, by = 2), 80:100))

}
\seealso{
\code{\link{sample_agecomp}} for more examples

Other sampling functions: \code{\link{clean_data}},
  \code{\link{sample_agecomp}},
  \code{\link{sample_calcomp}}, \code{\link{sample_index}},
  \code{\link{sample_mlacomp}},
  \code{\link{sample_wtatage}}
}
\author{
Cole Monnahan and Kotaro Ono
}
\concept{sampling functions}
