test_that("gm_mean returns a numeric", {
  expect_identical(gm_mean(numeric(0)), NaN)
  expect_identical(gm_mean(1), 1)
  expect_identical(gm_mean(-1), NaN)
  expect_identical(gm_mean(c(1, -1)), NaN)
  expect_identical(gm_mean(NA_real_), NA_real_)
  expect_identical(gm_mean(NA_real_, na.rm = TRUE), NaN)
  expect_identical(gm_mean(c(1, NA)), NA_real_)
  expect_identical(gm_mean(c(1, NA), na.rm = TRUE), 1)
  expect_identical(gm_mean(0), 0)
  expect_identical(gm_mean(0, zero.propagate = FALSE), NaN)
  expect_identical(gm_mean(c(1, 0)), 0)
  expect_identical(gm_mean(c(NA_real_, 0)), 0)
  expect_identical(gm_mean(c(NA_real_, 0), zero.propagate = FALSE), NA_real_)
  expect_identical(gm_mean(c(NA_real_, 0), na.rm = TRUE), 0)
  expect_identical(gm_mean(c(NA_real_, 0), na.rm = TRUE, zero.propagate = FALSE), NaN)
  expect_identical(gm_mean(c(1, 0), zero.propagate = FALSE), 1)
  expect_identical(gm_mean(1L), 1)
  expect_error(gm_mean("1"))
  expect_identical(round(gm_mean(c(13, 5, 70, 80))), 25)
})
