% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm_discretize.R
\name{spm_discretize}
\alias{spm_discretize}
\alias{spm_discretize,sspm_boundary,missing,ANY-method}
\alias{spm_discretize,sspm_boundary,ANY,missing-method}
\alias{spm_discretize,sspm_boundary,character,ANY-method}
\alias{spm_discretize,sspm_boundary,function,ANY-method}
\alias{spm_discretize,sspm_boundary,discretization_method,ANY-method}
\title{Discretize a \code{sspm} model object}
\usage{
spm_discretize(boundary_object, method = "tesselate_voronoi", with = NULL, ...)

\S4method{spm_discretize}{sspm_boundary,missing,ANY}(boundary_object, method = "tesselate_voronoi", with = NULL, ...)

\S4method{spm_discretize}{sspm_boundary,ANY,missing}(boundary_object, method = "tesselate_voronoi", with = NULL, ...)

\S4method{spm_discretize}{sspm_boundary,character,ANY}(boundary_object, method = "tesselate_voronoi", with = NULL, ...)

\S4method{spm_discretize}{sspm_boundary,function,ANY}(boundary_object, method = "tesselate_voronoi", with = NULL, ...)

\S4method{spm_discretize}{sspm_boundary,discretization_method,ANY}(boundary_object, method = "tesselate_voronoi", with = NULL, ...)
}
\arguments{
\item{boundary_object}{\strong{[sspm]} An object of class
\link[=sspm-class]{sspm_boundary}.}

\item{method}{\strong{[character OR method]}
Either a \code{character} from the list of available methods
(see \link{spm_methods} for the list) \strong{OR} an object of class
\link[=discretization_method-class]{discretization_method}.}

\item{with}{\strong{[sspm_dataset OR sf]} Either an object of class sspm_dataset or
a set of custom points.}

\item{...}{\strong{[named list]} Further arguments to be passed onto the function
used in \code{method}.}
}
\value{
An object of class \link[=sspm-class]{sspm_discrete_boundary} (the updated
and discretized \code{sspm} object given as input).
}
\description{
Discretize a \link[=sspm-class]{sspm} model object with a function from a
\link[=discretization_method-class]{discretization_method} object class. This
function divides the boundary polygons into smaller patches.
}
\details{
Custom discretization functions can be written. The function must:
\enumerate{
\item Accept at least 1 argument: \strong{boundaries} (the \code{sf} boundary object),
and optionnaly \strong{with} (can be NULL) a separate object to be used for
discretization and \strong{boundary}, the boundary column of
\strong{boundaries} (these last 2 arguments are passed and connot be
overwritten but could be ignored).
\item Returns a named list with 2 elements: \code{patches}. an \code{sf} object that
stores the discretized polygons, and \code{points}, an \code{sf} object that
stores the points that were used for discretization.
}
}
\examples{
# Voronoi tesselation
sfa_boundaries
bounds <- spm_as_boundary(boundaries = sfa_boundaries,
                          boundary = "sfa")
biomass_dataset <- spm_as_dataset(data.frame(borealis_simulated), name = "borealis",
                                  density = "weight_per_km2",
                                  time = "year_f",
                                  coords = c('lon_dec','lat_dec'),
                                  uniqueID = "uniqueID")
bounds_voronoi <- bounds \%>\%
  spm_discretize(method = "tesselate_voronoi",
                 with = biomass_dataset,
                 nb_samples = 10)

# Custom method
custom_func <- function(boundaries, ...){
  args <- list(...)
  # Can access passed arguments with args$arg_name
  # Do your custom discretization
  # Careful: must return sf objects!
  return(list(patches = c(),
              points = c())
         )
}

}
