% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{geom_eemregions}
\alias{geom_eemregions}
\title{Mark common reagions to EEMs to show molecular groups}
\usage{
geom_eemregions(
  lim = c(ex_min = 200, ex_max = 500, em_min = 250, em_max = 700),
  detail = TRUE,
  ...
)
}
\arguments{
\item{lim}{limit the extend of the lines separating the groups}

\item{detail}{logical, whether the reagions are given with numbers only or with more detailed information}

\item{...}{additional arguments to be passed on to \code{\link[ggplot2]{geom_function}}, \code{\link[ggplot2]{geom_segment}} and \code{\link[ggplot2]{geom_text}}}
}
\value{
a layer to a ggplot2
}
\description{
geom_eemregions marks the locations of commonly destinguished molecular groups in EEMs
}
\details{
data, the data.frame with the peaks, is included in the package and accessible using data(peaks).
It is possible to alter that data.frame and e.g. provide altered peaks or a selection of peaks using common functions on data.frames.
}
\examples{
require(tidyr)

eem_list \%>\%
  eem_extract(eem_names((eem_list))[1], keep = TRUE) \%>\%
  ggeem() +
  geom_eemregions()
}
