% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_toy_data.R
\name{generate_linear_dataset}
\alias{generate_linear_dataset}
\title{Generate a random binary dataset for classification}
\usage{
generate_linear_dataset(
  p,
  n,
  eps = 1.2,
  gamma = runif(1, min = -p, max = p),
  alpha = runif(p, min = -p, max = p)
)
}
\arguments{
\item{p}{number of variables.}

\item{n}{number of observations.}

\item{eps}{noise.}

\item{gamma}{numeric.}

\item{alpha}{numeric vector of length \code{n}.}
}
\value{
A data.frame with \code{n} independent random variables and
one class variable \code{C} computed as
\code{sign(sum(x * alpha) + runif(1, -eps, eps) + gamma)}.
}
\description{
Randomly generate a simple classification problem.
}
\examples{
DD <- generate_linear_dataset(p = 5, n = 1000)
}
