% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiCUMSUM.R
\name{multiCUMSUM}
\alias{multiCUMSUM}
\alias{print.multiCUMSUM}
\title{Multivariate CUMSUM test}
\usage{
multiCUMSUM(data, conf.level = 0.95, max.breaks = 7)
}
\arguments{
\item{data}{a \code{(T x N)} \code{matrix} or \code{data.frame} containing the \code{N} time series over period \code{T}}

\item{conf.level}{Confidence level. By default set to 0.95}

\item{max.breaks}{Integer, determines the highest number of common breaks from 1 to 7.}
}
\value{
\item{Lambda Test statistics}{a matrix of test statistics on the presence of a number of co-break equal to \code{max.breaks} in the conditional mean}
\item{Omega Test statistics}{a matrix of test statistics on the presence of a number of co-break equal to \code{max.breaks} in the conditional variance}
\item{Break location}{the index and the Date where the common breaks are located}
}
\description{
Function returns the test statistics for the presence of co-breaks in a set of multivariate time series.
}
\examples{
data(Realized)
testCS <- multiCUMSUM(Realized[,1:10], conf.level = 0.95)
print(testCS)
}
\references{
Aue A., Hormann S., Horvath  L.and Reimherr M. (2009), Break detection in the covariance structure of multivariate time series models. \emph{The Annals of Statistics}. 37: 4046-4087

Bai J., Lumsdaine R. L. and Stock J. H. (1998), Testing For and Dating Common Breaks in Multivariate Time Series. \emph{Review of Economic Studies}. 65: 395-432

Barassi M., Horvath L. and Yuqian Z. (2018), Change-Point Detection in the Conditional Correlation Structure of Multivariate Volatility Models. \emph{Journal of Business & Economic Statistics}
}
\author{
Andrea Bucci and Giulio Palomba
}
\keyword{VLSTAR}
