% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSBragg.R
\name{SSbragg}
\alias{SSbragg}
\alias{bragg.3.fun}
\alias{bragg.4.fun}
\alias{NLS.bragg.4}
\alias{NLS.bragg.3}
\alias{DRC.bragg.4}
\alias{DRC.bragg.3}
\title{Bragg's Equation}
\usage{
bragg.4.fun(X, b, c, d, e)
bragg.3.fun(X, b, d, e)
NLS.bragg.4(X, b, c, d, e)
NLS.bragg.3(X, b, d, e)
DRC.bragg.4()
DRC.bragg.3()
}
\arguments{
\item{X}{a numeric vector of values at which to evaluate the model}

\item{b}{model parameter (relates to slope at inflection point)}

\item{d}{model parameter (maximum value)}

\item{e}{model parameter (abscissa at maximum value)}

\item{c}{model parameter (lower asymptote)}
}
\value{
bragg.4.fun, bragg.3.fun, NLS.bragg.4 and NLS.bragg.3
return a numeric value, while DRC.bragg.4 and DRC.bragg.3 return
a list containing the nonlinear function and the self starter function
}
\description{
These functions provide the Bragg's equations, that is based on
the normal (Gaussian) distribution and it supports a maximum,
a minimum and inflection points. These functions provide the
equations with 4 (bragg.4.fun) and 3 (bragg.3.fun) parameters
with self-starters for the \code{\link{nls}}
function (NLS.bragg.4, NLS.bragg.3) and the self-starters for
the \code{\link[drc]{drm}} function in the drc package (DRC.bragg.4, DRC.bragg.3)
}
\details{
The Bragg's equation is parameterised as:
\deqn{ f(x) = c + \left(d - c \right) \, \exp(- b \cdot (X - e)^2) }
for the 4-parameter model. For the 3-parameter model, c is equal to 0.
 It depicts a bell-shaped curve
}
\examples{
library(statforbiology)
X <- c(5, 10, 15, 20, 25, 30, 35, 40, 45, 50)
Y1 <- c(0.1, 2, 5.7, 9.3, 19.7, 28.4, 20.3, 6.6, 1.3, 0.1)
Y2 <- Y1 + 2

# nls fit
mod.nls <- nls(Y1 ~ NLS.bragg.3(X, b, d, e) )
mod.nls2 <- nls(Y2 ~ NLS.bragg.4(X, b, c, d, e) )

# drm fit
mod.drc <- drm(Y1 ~ X, fct = DRC.bragg.3() )
mod.drc2 <- drm(Y2 ~ X, fct = DRC.bragg.4() )
plot(mod.drc, ylim = c(0, 30), log = "")
plot(mod.drc2, add = TRUE, col = "red")


}
\references{
Ratkowsky, DA (1990) Handbook of nonlinear regression models. New York (USA): Marcel Dekker Inc.

Onofri, A. (2020). A collection of self-starters for nonlinear regression in R. See: \url{https://www.statforbiology.com/2020/stat_nls_usefulfunctions/}
}
\author{
Andrea Onofri
}
