% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detrender.R
\name{detrender}
\alias{detrender}
\title{Within-unit linear detrending for multilevel VAR analysis}
\usage{
detrender(
  df,
  id_var,
  time_var,
  vars_to_detrend,
  alpha = 0.05,
  min_obs = 3
)
}
\arguments{
\item{df}{Data frame or tibble (long format).}

\item{id_var}{Character string. Unit (subject) identifier column (required).}

\item{time_var}{Character string. Numeric time index column (required).}

\item{vars_to_detrend}{Character vector. Column names to detrend within each unit (subject) (required).}

\item{alpha}{Numeric in (0,1). Significance threshold for retaining a non-zero time slope (default: 0.05).}

\item{min_obs}{Integer >2. Minimum observations per unit-variable to attempt detrending (default: 3).}
}
\value{
A named list with:
\describe{
  \item{\code{df}}{Tibble. The original dataset with additional detrended columns.}
  \item{\code{n_units}}{Integer. Number of unique units (subjects) processed.}
  \item{\code{total_trends}}{Integer. Total number of individual trends removed across all variables.}
  \item{\code{summary}}{Tibble. Number of removed linear trends per variable, with columns \code{variable} and \code{removed_trends}.}
}
}
\description{
Remove unit-specific linear trends from panel data to approximate stationarity,
preparing inputs for multilevel Vector Autoregressive (VAR) modeling (among others). 
For each unit (subject) and each selected variable, a linear regression of the variable 
on the time index is tested at significance level \code{alpha}; if the slope 
is significant, the fitted trend is subtracted and the mean of the unit is 
re-added, to produce detrended series while preserving between-unit information.   
  
Caution: models with lagged outcomes and per-unit intercepts (fixed or random) 
are prone to Nickell-type bias when there are fewer than
10 time points (T) per unit; detrending does not remove it. \code{T >= 10} is 
recommended (Nickell, 1981; Judson & Owen, 1999).   
For VAR(1) with an intercept and linear trend, a minimum of \code{K + 4} 
time points per unit (where \code{K} is the number of detrended series) is 
required to maintain positive residual degrees of freedom (Lütkepohl, 2005).
}
\examples{
df_example <- data.frame(
id = rep(1:2, each = 5),
time = rep(1:5, 2),
x = rep(1:5, 2) + rnorm(10)
)
res <- statioVAR::detrender(
df = df_example,
id_var = "id",
time_var = "time",
vars_to_detrend = "x",
alpha = 0.05,
min_obs = 3
)
res$df[7:9,]
res$n_units
res$total_trends
res$summary

}
\references{
Judson, R. A., & Owen, A. L. (1999). Estimating dynamic panel data models: a guide for macroeconomists. Economics letters, 65(1), 9-15. \doi{10.1016/s0165-1765(99)00130-5}     

Lütkepohl, H. (2005). New Introduction to Multiple Time Series Analysis. Springer Berlin Heidelberg. \doi{10.1007/978-3-540-27752-1}   

Nickell, S. (1981). Biases in dynamic models with fixed effects. Econometrica: Journal of the econometric society, 1417-1426. \doi{10.2307/1911408}
}
