% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{ci.cronbach}
\alias{ci.cronbach}
\title{Confidence interval for a Cronbach reliability}
\usage{
ci.cronbach(alpha, rel, r, n)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{rel}{estimated Cronbach reliability}

\item{r}{number of measurements (items, raters, forms)}

\item{n}{sample size}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated Cronbach reliability (from input)
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a population Cronbach reliability.
The point estimate of Cronbach reliability assumes essentially
tau-equivalent measurements and the confidence interval assumes parallel
measurements.

For more details, see Section 4.19 of Bonett (2021, Volume 1)
}
\examples{
ci.cronbach(.05, .85, 7, 89)

# Should return:
# Estimate       SE     LL     UL
#     0.85  0.02457 0.7971 0.8932
 

}
\references{
\insertRef{Feldt1965}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
