% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxph_methods.R
\name{tidy.std_surv}
\alias{tidy.std_surv}
\title{Provide tidy output from a std_surv object for use in downstream computations}
\usage{
\method{tidy}{std_surv}(x, ...)
}
\arguments{
\item{x}{An object of class std_surv}

\item{...}{Not currently used}
}
\value{
A data.frame
}
\description{
Tidy summarizes information about the components of the standardized model fit.
}
\examples{
require(survival)
set.seed(8)
n <- 300
Z <- rnorm(n)
X <- rnorm(n, mean = Z)
time <- rexp(n, rate = exp(X + Z + X * Z)) # survival time
C <- rexp(n, rate = exp(X + Z + X * Z)) # censoring time
U <- pmin(time, C) # time at risk
D <- as.numeric(time < C) # event indicator
dd <- data.frame(Z, X, U, D)
x <- standardize_coxph(
  formula = Surv(U, D) ~ X + Z + X * Z,
  data = dd, values = list(X = seq(-1, 1, 0.5)), times = c(2,3,4)
)

tidy(x)

}
