% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum_items_to_scale.R
\name{sum_items_to_scale}
\alias{sum_items_to_scale}
\title{Sum up discrete raw data}
\usage{
sum_items_to_scale(data, ..., retain = FALSE, .dots = list())
}
\arguments{
\item{data}{\code{data.frame} object containing numerical values of items data}

\item{...}{objects of class \code{ScaleSpec} or \code{CombScaleSpec}. If all item names
are found in \code{data}, summed items will be available in returned data.frame
as column named as their \code{name} value.}

\item{retain}{either \code{boolean}: \code{TRUE} if all columns in the \code{data} are to be
retained, \code{FALSE} if none, or character vector with names of columns to be retained}

\item{.dots}{\code{ScaleSpec} or \code{CombScaleSpec} objects provided as a list, instead
of individually in \code{...}.}
}
\value{
object of class \code{data.frame}
}
\description{
Helper function to sum-up and - if needed - automatically
reverse discrete raw item values to scale or factor that they
are measuring.
}
\details{
All summing up of the raw discrete values into scale or factor
score is done according to provided specifications utilizing \code{\link[=ScaleSpec]{ScaleSpec()}}
objects. For more information refer to their constructor help page.
}
\examples{
# create the Scale Specifications for SLCS dataset
## Self-Liking specification
SL_spec <- ScaleSpec(
  name = "Self-Liking",
  item_names = paste("SLCS", c(1, 3, 5, 6, 7, 9, 11, 15), sep = "_"),
  reverse = paste("SLCS", c(1, 6, 7, 15), sep = "_"),
  min = 1,
  max = 5)

## Self-Competence specification
SC_spec <- ScaleSpec(
  name = "Self-Competence",
  item_names = paste("SLCS", c(2, 4, 8, 10, 12, 13, 14, 16), sep = "_"),
  reverse = paste("SLCS", c(8, 10, 13), sep = "_"),
  min = 1,
  max = 5)

## General Score specification
GS_spec <- CombScaleSpec(
  name = "General Score",
  SL_spec,
  SC_spec)

# Sum the raw item scores to raw scale scores
SLCS_summed <- sum_items_to_scale(SLCS, SL_spec, SC_spec, GS_spec, retain = "user_id")
summary(SLCS_summed)
}
\seealso{
Other item preprocessing functions: 
\code{\link{CombScaleSpec}()},
\code{\link{ScaleSpec}()}
}
\concept{item preprocessing functions}
