% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valueCoordinates.R
\name{valueCoordinates}
\alias{valueCoordinates}
\title{Locate Specific Values in a Data Frame}
\usage{
valueCoordinates(df, value = NA, eq_fun = value_check)
}
\arguments{
\item{df}{A data.frame to search}

\item{value}{The target value to find (default: NA)}

\item{eq_fun}{A comparison function that takes two parameters: the current value
from the data.frame and the target value. Returns TRUE for matches.
Default uses internal value_check function; handles NA values.}
}
\value{
A data.frame with two columns:
\describe{
  \item{column}{Column indices where matches were found}
  \item{row}{Row indices where matches were found}
}
Results are sorted by column, then by row.
}
\description{
Finds the positions (row and column indices) of values in a data.frame that match
specified criteria. This function is useful for locating particular values within
large datasets.
}
\examples{
# Sample data.frame
df <- data.frame(
  a = c(1, NA, 3),
  b = c(NA, 2, NA),
  c = c(3, 2, 1)
)

# Find NA positions
valueCoordinates(df)

# Find positions of value 2
valueCoordinates(df, 2)

# Find positions where values exceed 2
valueCoordinates(df, 2, function(x, y) x > y)

# Find positions of values in range [1,3]
valueCoordinates(df, c(1, 3), function(x, y) x >= y[1] & x <= y[2])

}
