% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_sw_analysis.R
\name{print.sw_analysis}
\alias{print.sw_analysis}
\title{Summarize a list returned by steppedwedge::analysis()}
\usage{
\method{print}{sw_analysis}(x, ...)
}
\arguments{
\item{x}{A list returned by steppedwedge::analysis()}

\item{...}{Additional arguments}
}
\value{
A summary of the analysis object, including an estimate and 95% CI for the treatment effect, and messages on convergence.
}
\description{
Summarize a list returned by steppedwedge::analysis()
}
\examples{
# Load data
test_data <- load_data(time ="period", cluster_id = "cluster", individual_id = NULL,
treatment = "trt", outcome = "outcome_bin", data = sw_data_example)

# Analysis example: TATE estimand for exposure times 1 through 4
results_tate <- analyze(dat = test_data, method = "mixed", estimand_type = "TATE",
estimand_time = c(1, 4), exp_time = "ETI", family = poisson)

results_tate
}
