% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circdiff.R
\name{circdiff}
\alias{circdiff}
\title{Estimation of circular diffusion models}
\usage{
circdiff(theta, dt, corr_process, iter=2000, lambda=0, lambda_1=0, lambda_2=0)
}
\arguments{
\item{theta}{data of the discretely observed diffusion}

\item{dt}{time step \eqn{\Delta t}}

\item{corr_process}{\code{vmp} for von-Mises process; \code{cbm} for circular brownian motion}

\item{iter}{number of iterations (Default is 2000)}

\item{lambda}{regularization parameter for \code{cbm} (Default is 0)}

\item{lambda_1}{regularization parameter for \code{vmp} (Default is 0)}

\item{lambda_2}{regularization parameter for \code{vmp} (Default is 0)}
}
\value{
A list containing the estimates of the model
if \code{corr_process=vmp} then it returns
\itemize{
\item \code{dt} time step \eqn{\Delta t}
\item \code{lambda_vm} the drift parameter of the von Mises process
\item \code{sigma_vm} the volatility parameter of the von Mises process
\item \code{mu_vm} the mean direction of the von Mises process
\item \code{lambda_1, lambda_2} value of the regularization parameters used for estimation
}
else if \code{corr_process=cbm} then it returns
\itemize{
\item \code{dt} time step \eqn{\Delta t}
\item \code{sigma_cbm} the volatility parameter of the circular Brownian motion
\item \code{lambda} value of the regularization parameter used for estimation
}
}
\description{
\code{circdiff} returns the estimates of parameters of a discretely observed von-Mises process or Circular Brownian motion
}
\details{
Let \eqn{\theta_0,\theta_{\Delta t},\theta_{2\Delta t}, \ldots, \theta_{n\Delta t}} be a discretely observed circular diffusion
at time step \eqn{\Delta t}. The circular diffusion could either be von-Mises process,
\deqn{d\theta_t=-\lambda\sin(\theta_t-\mu)dt+\sigma dW_t}
or the circular brownian motion,
\deqn{d\theta_t=\sigma dW_t}
under periodic boundary condition. The function returns the MLE of \eqn{\lambda,\sigma,\mu} for von-Mises process or
\eqn{\sigma} for circular brownian motion.

We provide an option to perform penalised MLE using an iterative optimization procedure as following,
we maximise for von Mises process, where \eqn{n} is the number of observations,
\deqn{\text{Log-lik}-n\lambda_1\sum(1-cos(\theta_{i+1}-\theta_{i}))-\lambda_2\frac{2\lambda}{\sigma^2}}
For Circular Brownian motion we maximise,
\deqn{\text{Log-lik}-n\lambda\sum(1-cos(\theta_{i+1}-\theta_{i}))}

See section 3 of Majumdar and Laha (2024) \url{doi:10.48550/arXiv.2412.06343}.
}
\examples{
\donttest{
library(stochcorr)

data(wind)
if(requireNamespace("ggplot2")){
library(ggplot2)
ggplot2::ggplot(wind, aes(x = Date, y = Dir)) +
  geom_line() +
  labs(title = "Sotavento Wind Farm",
       x = "Date",
       y = "Wind Direction") +
  scale_x_datetime(date_labels = "\%d-\%b", date_breaks = "2 day") +
  theme_test() +
  theme(
    text = element_text(size = 15),
    axis.text.x = element_text(angle = 90, hjust = 1)
  )
 }

a<-circdiff(wind$Dir,10/1440,"vmp")
a

b<-circdiff(wind$Dir,10/1440,"cbm")
b}
}
\seealso{
\code{\link[=circ.bootstrap]{circ.bootstrap()}}
}
