#include <Rcpp.h>
#include <math.h>
#include "vmp_tpd.h"

//' @export
// [[Rcpp::export]]

double normalizing_constant(double dt, double theta_0, double mu, double lambda, double sigma, double len=25){
  double spacing {2*M_PI/(len-1)};
  Rcpp::NumericVector theta = {-1*M_PI};;
  for(int i=1; i<len ; i++){
    theta.push_back(theta[i-1]+spacing);
  }
  Rcpp::NumericVector ang (len);
    for(int i=0; i< len; i++){
      ang[i]=vmp_tpd(dt,theta[i],theta_0,lambda,sigma,mu);
    }
  double n_constant = sum(ang*spacing);
  return(n_constant);
}
