% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opchars.tite.R
\name{opchars.tite}
\alias{opchars.tite}
\title{Operating Characteristics Function (TITE Method)}
\usage{
opchars.tite(rule, p, tau, MC, A, family, s)
}
\arguments{
\item{rule}{A \code{rule.tite} object with the safety stopping rule for evaluation}

\item{p}{Vector of cumulative incidence probabilities at time \code{tau} for all causes (length 1 for survival, 2 for competing risks)}

\item{tau}{Length of observation period}

\item{MC}{Number of Monte Carlo replicated datasets to simulate}

\item{A}{Length of accrual period}

\item{family}{Event time distribution, choices including Weibull distribution ('weibull') and power family ('power')}

\item{s}{Shape parameter for Weibull distribution or power parameter for power family}
}
\value{
A list containing the toxicity probability \code{p}, and the corresponding rejection probability and expected number of events. If \code{tau} and \code{A} are also specified, the expected number of enrolled patients and the expected calendar time at the point of stopping/study end are also included.
}
\description{
Internal workhorse function to calculate operating characteristics for a given stopping rule and toxicity probability
}
