% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{delete_built_in_proposal}
\alias{delete_built_in_proposal}
\title{Delete Built-in Proposal}
\usage{
delete_built_in_proposal(sampling_function, proposal_type = "custom")
}
\arguments{
\item{sampling_function}{String. The name of the sampling distribution's function in STORS.
For example, \code{"srgamma"} or \code{"srchisq"}.}

\item{proposal_type}{String. Either \code{"custom"} to delete the custom proposal or \code{"scaled"} to delete the scaled proposal.
Defaults to \code{"custom"}.}
}
\value{
A message indicating the status of the deletion process, or an error if the operation fails.
}
\description{
This function deletes built-in proposals from disk by specifying the sampling function and proposal type.
It is useful for managing cached proposals and freeing up storage space.
}
\details{
The function looks for the specified proposal type associated with the sampling function in the built-in proposals directory.
If the proposal exists, it deletes the corresponding proposal file from disk and frees its cached resources.
If the specified sampling function or proposal type does not exist, an error is thrown.
}
\examples{

# The following examples are not run, since if they are run the srgamma and
# srnorm samplers will no longer work until a new grid is built for them.
# This causes problems if the examples are run by CRAN checks or the website
# build system.
\dontrun{
# Delete a custom proposal for the srgamma function (uncomment to run)
delete_built_in_proposal(sampling_function = "srgamma", proposal_type = "custom")

# Delete a scaled proposal for the srnorm function (uncomment to run)
delete_built_in_proposal(sampling_function = "srnorm", proposal_type = "scaled")
}

}
