% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srgamma.R
\name{srgamma_custom}
\alias{srgamma_custom}
\title{Sampling from Gamma Distribution}
\usage{
srgamma_custom(n = 1, x = NULL)
}
\arguments{
\item{n}{Integer, length 1. Number of samples to draw.}

\item{x}{(optional) Numeric vector of length \eqn{n}. If provided, this vector is overwritten in place to avoid any memory allocation.}
}
\value{
A numeric vector of length \code{n} containing random samples from the Gamma distribution.
The \code{shape} and \code{rate} parameters are specified during the optimization process using \code{srgamma_optimize()}.

\bold{NOTE:} When the \code{x} parameter is specified, it is updated in-place with the simulation for performance reasons.
}
\description{
The \code{srgamma_custom()} function generates random samples from a Gamma distribution using the STORS algorithm.
It employs an optimized proposal distribution around the mode and Adaptive Rejection Sampling (ARS) for the tails.
}
\details{
The Gamma Distribution

The Gamma distribution has the probability density function (PDF):
\deqn{f(x | \alpha, \beta) = \frac{\beta^\alpha}{\Gamma(\alpha)} x^{\alpha - 1} \exp(-\beta x), \quad x \geq 0,}
where:
\describe{
\item{\eqn{\alpha}}{is the shape parameter (\eqn{\alpha > 0}), which determines the shape of the distribution.}
\item{\eqn{\beta}}{is the rate parameter (\eqn{\beta > 0}), which determines the rate of decay.}
}
The Gamma distribution is widely used in statistics, particularly in Bayesian inference and modelling waiting times.

This function samples from a proposal constructed using \code{\link{srgamma_optimize}}, employing the STORS algorithm.

By default, \code{srgamma_custom()} samples from the standard Gamma distribution with \code{shape = 1} and \code{rate = 1}.
The proposal distribution is pre-optimized at package load time using \code{srgamma_optimize()} with
\code{steps = 4091}, creating a scalable proposal centred around the mode.
}
\note{
This function is not scalable. Therefore, only the \code{srgamma_custom()} version is available, which requires the proposal to be pre-optimized using \code{srgamma_optimize()} before calling this function.
}
\examples{
# Generate 10 samples from Gamma Distribution
samples <- srgamma_custom(10)
print(samples)

# Generate 10 samples using a pre-allocated vector
x <- numeric(10)
srgamma_custom(10, x = x)
print(x)

}
\seealso{
\code{\link{srgamma_optimize}} to optimize the custom proposal.
}
