% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srpareto.R
\name{srpareto_custom}
\alias{srpareto_custom}
\title{Sampling from Pareto Distribution}
\usage{
srpareto_custom(n = 1, x = NULL)
}
\arguments{
\item{n}{Integer, length 1. Number of samples to draw.}

\item{x}{(optional) Numeric vector of length \eqn{n}. If provided, this vector is overwritten in place to avoid any memory allocation.}
}
\value{
A numeric vector of length \code{n} containing random samples from the Pareto distribution.
The \code{shape} and \code{scale} parameters are specified during the optimization process using \code{srpareto_optimize()}.

\bold{NOTE:} When the \code{x} parameter is specified, it is updated in-place with the simulation for performance reasons.
}
\description{
The \code{srpareto_custom()} function generates random samples from a Pareto distribution using the STORS algorithm.
It employs an optimized proposal distribution around the mode and Inverse Transform (IT) method for the tails.
}
\details{
The Pareto Distribution

The Pareto distribution has the probability density function (PDF):
\deqn{f(x | \alpha, \sigma) = \frac{\alpha \sigma^\alpha}{x^{\alpha + 1}}, \quad x \geq \sigma,}
where:
\describe{
\item{\eqn{\alpha}}{is the shape parameter (\eqn{\alpha > 0}), which determines the tail heaviness of the distribution.}
\item{\eqn{\sigma}}{is the scale parameter (\eqn{\sigma > 0}), which determines the minimum possible value of \eqn{x}.}
}
The Pareto distribution is widely used in modelling phenomena with heavy tails, such as wealth distribution, insurance losses, and natural events.

This function samples from a proposal constructed using \code{\link{srpareto_optimize}}, employing the STORS algorithm.

By default, \code{srpareto_custom()} samples from the standard Pareto distribution with \code{shape = 1} and \code{rate = 1}.
The proposal distribution is pre-optimized at package load time using \code{srpareto_optimize()} with
\code{steps = 4091}, creating a scalable proposal centred around the mode.
}
\note{
This function is not scalable. Therefore, only the \code{srpareto_custom()} version is available, which requires the proposal to be pre-optimized using \code{srpareto_optimize()} before calling this function.
}
\examples{
# Generate 10 samples from Pareto Distribution
samples <- srpareto_custom(10)
print(samples)

# Generate 10 samples using a pre-allocated vector
x <- numeric(10)
srpareto_custom(10, x = x)
print(x)

}
\seealso{
\code{\link{srpareto_optimize}} to optimize the custom proposal.
}
