% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_session_cases.R
\name{get_session_cases}
\alias{get_session_cases}
\title{Cases in specified session}
\usage{
get_session_cases(sessionid = NA, good_manners = 0, cores = 1)
}
\arguments{
\item{sessionid}{Character string indicating the id of the parliamentary session to retrieve.}

\item{good_manners}{Integer. Seconds delay between calls when making multiple calls to the same function}

\item{cores}{Integer. Number of cores (1 by default) to use in structuring the data.
More than 1 will not work on windows}
}
\value{
A data.frame with the following variables:
\enumerate{
\item \strong{$root} (main data on the MP)\tabular{ll}{
    \tab  \cr
   \strong{response_date} \tab Date of data retrieval \cr
   \strong{version} \tab Data version from the API \cr
   \strong{treated_session_id} \tab Session the case was treated in \cr
   \strong{document_group} \tab Document group the case belongs to \cr
   \strong{reference} \tab Document reference \cr
   \strong{id} \tab Case id \cr
   \strong{com_req_id} \tab Committee recommendation id \cr
   \strong{com_req_code} \tab Committee recommendation code \cr
   \strong{title_short} \tab Short title of case \cr
   \strong{case_filed_id} \tab Id of filed case \cr
   \strong{last_update_date} \tab Date of last update on case \cr
   \strong{status} \tab Status of the case \cr
   \strong{title} \tab Full title of the case \cr
   \strong{type} \tab Type of case \cr
   \strong{session_id} \tab Session id of the case \cr
   \strong{committee_id} \tab Responsible committee id \cr
}

\item \strong{$topics} (named list by case id)\tabular{ll}{
    \tab  \cr
   \strong{is_main_topic} \tab Logical indication whether the topic is the main topic \cr
   \strong{main_topic_id} \tab Id of the main topic for the case \cr
   \strong{id} \tab Topic id \cr
   \strong{name} \tab Topic name \cr
}

\item \strong{$proposers} (named list by case id)\tabular{ll}{
    \tab  \cr
   \strong{rep_id} \tab Proposing MP id \cr
   \strong{county_id} \tab County id of proposing MP \cr
   \strong{party_id} \tab Party id of proposing MP \cr
   \strong{rep_sub} \tab Logical indicator for whether MP is a substitute \cr
}

\item \strong{$spokespersons} (data frame by case id)\tabular{ll}{
    \tab  \cr
   \strong{case_id} \tab Case id \cr
   \strong{rep_id} \tab Spokesperson(s) MP id for the case \cr
   \strong{county_id} \tab County id of spokesperson MP \cr
   \strong{party_id} \tab Party id of spokesperson MP \cr
   \strong{rep_sub} \tab Logical indicator for whether MP is a substitute \cr
}

}
}
\description{
A function for retrieving all cases treated in a specified parliamentary session.
}
\examples{

\dontrun{
s0506 <- get_session_cases("2005-2006")
head(s0506)
}

}
\seealso{
\link{get_case} \link{get_vote}
}
