% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithms_1sided.R
\name{rna_prior}
\alias{rna_prior}
\title{RNA in version that uses prior information about violations}
\usage{
rna_prior(
  total_cost,
  A,
  bounds = NULL,
  check = NULL,
  check_violations = .Primitive(">="),
  details = FALSE
)
}
\arguments{
\item{total_cost}{(\code{number})\cr total cost \eqn{c} of the survey. A strictly
positive scalar.}

\item{A}{(\code{numeric})\cr population constants \eqn{A_1,\ldots,A_H}. Strictly
positive numbers.}

\item{bounds}{(\code{numeric} or \code{NULL}) \cr optional lower bounds
\eqn{m_1,\ldots,m_H}, or upper bounds \eqn{M_1,\ldots,M_H}, or \code{NULL} to
indicate that there is no inequality constraints in the optimization
problem considered.
If not \code{NULL}, the \code{bounds} is to be treated either as:
\itemize{
\item lower bounds, if \code{check_violations = .Primitive("<=")}. In this case, it
is required that \code{total_cost >= sum(unit_costs * bounds)}, \cr
or
\item upper bounds, if \code{check_violations = .Primitive(">=")}. In this case, it
is required that \code{total_cost <= sum(unit_costs * bounds)}.
}}

\item{check}{(\code{integer})\cr strata indices for which the allocation can
possible be violated. For other strata allocation cannot be violated.}

\item{check_violations}{(\code{function}) \cr 2-arguments binary operator function
that allows the comparison of values in atomic vectors. It must either be
set to \code{.Primitive("<=")} or \code{.Primitive(">=")}. The first of these choices
causes that \code{bounds} are treated as lower bounds and then \code{rna()} function
performs the \emph{LRNA} algorithm. The latter option causes that \code{bounds}
are treated as upper bounds, and then \code{rna()} function performs the
\emph{RNA} algorithm. This argument is ignored when \code{bounds} is set to \code{NULL}.}

\item{details}{(\code{flag}) \cr should detailed information about strata
assignments (either to take-Neyman or take-bound), values of set function
\eqn{s} and number of iterations be added to the output?}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This is the version of the RNA that makes use of additional information
about strata for which the allocation can possibly be violated. For all other
strata allocation will not be violated.
}
\note{
this coded was not extensively tested.
}
