% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratifiedyh.R
\name{cluster_labels}
\alias{cluster_labels}
\title{Cluster Sampling and Labeling}
\usage{
cluster_labels(df, group_col, yes_percentage)
}
\arguments{
\item{df}{A data frame containing the data.}

\item{group_col}{A character string specifying the column to use for clustering.}

\item{yes_percentage}{A numeric value between 0 and 100 indicating the percentage of clusters to label as "Yes".}
}
\value{
A data frame with an additional column "Clustered_Yes_No" containing the cluster-sampled "Yes"/"No" labels.
}
\description{
This function performs cluster sampling on the dataframe and assigns "Yes" or "No" labels to rows based on selected clusters.
}
\examples{
result <- cluster_labels(iris, group_col = "Species", yes_percentage = 50)
}
