% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animate_cluster.R
\name{animate_cluster}
\alias{animate_cluster}
\title{Animates Plots of the Clustering Process}
\usage{
animate_cluster(
  dsc,
  dsd,
  measure = NULL,
  horizon = 100,
  n = 1000,
  type = c("auto", "micro", "macro"),
  assign = "micro",
  assignmentMethod = c("auto", "model", "nn"),
  excludeNoise = FALSE,
  wait = 0.1,
  plot.args = NULL,
  ...
)
}
\arguments{
\item{dsc}{a \link{DSC}}

\item{dsd}{a \link{DSD}}

\item{measure}{the evaluation measure that should be graphed below the
animation (see \code{\link[=evaluate_stream]{evaluate_stream()}}.)}

\item{horizon}{the number of points displayed at once/used for evaluation.}

\item{n}{the number of points to be plotted}

\item{type, assign, assignmentMethod, excludeNoise}{are passed on to \code{\link[=evaluate_stream]{evaluate_stream()}} to calculate the
evaluation measure.}

\item{wait}{the time interval between each frame}

\item{plot.args}{a list with plotting parameters for the clusters.}

\item{...}{extra arguments are added to \code{plot.args}.}
}
\description{
Generates an animation of a data stream clustering process.
}
\details{
Animations are recorded using the library animation and can be replayed
(which gives a smoother experience since the is no more computation done)
and saved in various formats (see Examples section below).

\strong{Note:} You need to install package \pkg{animation} and its system requirements.
}
\examples{
if (interactive()) {
stream <- DSD_Benchmark(1)

### animate the clustering process with evaluation
### Note: we choose to exclude noise points from the evaluation
###       measure calculation, even if the algorithm would assign
###       them to a cluster.
dbstream <- DSC_DBSTREAM(r = .04, lambda = .1, gaptime = 100, Cm = 3,
  shared_density = TRUE, alpha = .2)

animate_cluster(dbstream, stream, horizon = 100, n = 5000,
  measure = "crand", type = "macro", assign = "micro",
  plot.args = list(xlim = c(0, 1), ylim = c(0, 1), shared = TRUE))
}
}
\seealso{
\code{\link[animation:ani.record]{animation::ani.replay()}} for replaying and saving animations.

Other DSC: 
\code{\link{DSC}()},
\code{\link{DSC_Macro}()},
\code{\link{DSC_Micro}()},
\code{\link{DSC_R}()},
\code{\link{DSC_SlidingWindow}()},
\code{\link{DSC_Static}()},
\code{\link{DSC_TwoStage}()},
\code{\link{evaluate.DSC}},
\code{\link{get_assignment}()},
\code{\link{plot.DSC}()},
\code{\link{predict}()},
\code{\link{prune_clusters}()},
\code{\link{read_saveDSC}},
\code{\link{recluster}()}

Other plot: 
\code{\link{animate_data}()},
\code{\link{plot.DSC}()},
\code{\link{plot.DSD}()}

Other evaluation: 
\code{\link{evaluate}},
\code{\link{evaluate.DSC}}
}
\author{
Michael Hahsler
}
\concept{DSC}
\concept{evaluation}
\concept{plot}
