% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strvalidator-package.r
\docType{package}
\name{strvalidator-package}
\alias{strvalidator-package}
\title{Process Control and Internal Validation of Forensic STR Kits}
\description{
STR-validator is a free and open source R package intended for
process control and internal validation of forensic STR DNA typing kits.
Its graphical user interface simplifies the analysis of data exported from e.g.
GeneMapper software, without extensive knowledge about R. It provides
functions to import, view, edit, and export data. After analysis the results,
generated plots, heat-maps, and data can be saved in a project for easy access.
Currently, analysis modules for stutter, balance, dropout, mixture, concordance,
typing result, precision, pull-up, and analytical thresholds are available.
In addition there are functions to analyze the GeneMapper bins- and panels files.
EPG-like plots can be generated from data. STR-validator can greatly increase the speed of
validation by reducing the time and effort needed to analyze the validation
data. It allows exploration of the characteristics of DNA typing kits according
to ENFSI and SWGDAM recommendations. This facilitates the implementation of
probabilistic interpretation of DNA results.
}
\details{
STR-validator was written and is maintained by Oskar Hansson, senior forensic
scientist at Oslo University Hospital (OUS), Section for Forensic Biology.
The work initially received external funding from the European
Union seventh Framework Programme (FP7/2007-2013) under grant agreement no
285487 (EUROFORGEN-NoE) but development and maintenance is now performed as
a part of my position at OUS, and on personal spare time.\cr\cr

Effort has been made to assure correct results. Refer to the main website
for a list of functions specifically tested at build time.\cr\cr

Click \code{Index} at the bottom of the page to see a complete list of
functions.\cr\cr

Created and maintained by:\cr
Oskar Hansson, Section for Forensic Biology (OUS, Norway)\cr
\email{oskhan@ous-hf.no}\cr\cr

More information can be found at:\cr
\url{https://sites.google.com/site/forensicapps/strvalidator}\cr\cr

Info and user community at Facebook:\cr
\url{https://www.facebook.com/pages/STR-validator/240891279451450?ref=tn_tnmn}\cr
\url{https://www.facebook.com/groups/strvalidator/}\cr\cr

The source code is hosted at GitHub:\cr
\url{https://github.com/OskarHansson/strvalidator}\cr\cr

Please report bugs to:\cr
\url{https://github.com/OskarHansson/strvalidator/issues}\cr\cr
}
\references{
Recommended Minimum Criteria for the Validation of Various Aspects of the DNA Profiling Process:
\url{http://enfsi.eu/wp-content/uploads/2016/09/minimum_validation_guidelines_in_dna_profiling_-_v2010_0.pdf}\cr
Validation Guidelines for Forensic DNA Analysis Methods (2012):
\url{http://media.wix.com/ugd/4344b0_cbc27d16dcb64fd88cb36ab2a2a25e4c.pdf}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://sites.google.com/site/forensicapps/strvalidator}
  \item Report bugs at \url{https://github.com/OskarHansson/strvalidator/issues}
}

}
\author{
\strong{Maintainer}: Oskar Hansson \email{oskhan@ous-hf.no}

}
\keyword{internal}
