% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fatTrim.R
\name{fatTrim}
\alias{fatTrim}
\title{fatTrim: Supporting function to reduce the size of models}
\usage{
fatTrim(cmx)
}
\arguments{
\item{cmx}{A model object.}
}
\value{
A model object.
}
\description{
fatTrim: Supporting function to reduce the size of models
}
\examples{
set.seed(1)

##########################
##### Simulate Data ######
##########################

# create training dataset with 10 studies, 2 covariates
X <- matrix(rnorm(2000), ncol = 2)

# true beta coefficients
B <- c(5, 10, 15)

# outcome vector
y <- cbind(1, X) \%*\% B

# study names
study <- sample.int(10, 1000, replace = TRUE)
data <- data.frame( Study = study,
                    Y = y,
                    V1 = X[,1],
                    V2 = X[,2] )

##########################
##### Model Fitting #####
##########################

# Fit model with 1 Single-Study Learner (SSL): Linear Regression
mod1 <- lm(formula = Y ~., data = data)


############################################
##### Fat Trim to reduce model size #####
############################################

mod1.trim <- fatTrim(mod1)

# compare sizes
object.size(mod1)
object.size(mod1.trim)
}
