% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stylest2_select_vocab.R
\name{stylest2_select_vocab}
\alias{stylest2_select_vocab}
\title{Cross-validation based term selection}
\usage{
stylest2_select_vocab(
  dfm,
  smoothing = 0.5,
  cutoffs = c(50, 60, 70, 80, 90, 99),
  nfold = 5,
  terms = NULL,
  term_weights = NULL,
  fill = FALSE,
  fill_weight = NULL,
  suppress_warning = TRUE
)
}
\arguments{
\item{dfm}{a quanteda \code{dfm} object.}

\item{smoothing}{the smoothing parameter value for smoothing the dfm. Should 
be a numeric scalar, default to 0.5.}

\item{cutoffs}{a numeric vector of cutoff candidates.}

\item{nfold}{number of folds for the cross-validation}

\item{terms}{If not \code{NULL}, terms to be used in the model. If \code{NULL}, 
use all terms.}

\item{term_weights}{Named vector of distances (or any weights) per term in the 
vocab. Names should correspond to the term.}

\item{fill}{Should missing values in term weights be filled? Defaults to FALSE.}

\item{fill_weight}{Numeric value to fill in as weight for any term which does 
not have a weight specified in \code{term_weights}.}

\item{suppress_warning}{TRUE/FALSE, indicate whether to suppress warnings from
\code{stylest2_fit()}.}
}
\value{
List of: best cutoff percent with the best speaker classification
  rate; cutoff percentages that were tested; matrix of the mean percentage of
  incorrectly identified speakers for each cutoff percent and fold; and the
  number of folds for cross-validation.
}
\description{
K-fold cross validation to determine the optimal cutoff on the term frequency 
distribution under which to drop terms.
}
\examples{
data(novels_dfm)
stylest2_select_vocab(dfm=novels_dfm)

}
