% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic_modeling.R
\name{topic_modeling}
\alias{topic_modeling}
\title{Topic Modeling with Latent Dirichlet Allocation (LDA)}
\usage{
topic_modeling(
  word_counts,
  seeded_topics,
  seed_weight,
  nr_topics,
  set_seed,
  lda_seed,
  lda_alpha,
  lda_best,
  lda_burnin,
  lda_verbose,
  lda_iter,
  lda_thin
)
}
\arguments{
\item{word_counts}{A data frame or data.table containing word counts, with columns for the document ID (\code{mID}), word (\code{word}), and count (\code{n}).}

\item{seeded_topics}{A list of character vectors representing predefined terms for each seed topic. If provided, seeded LDA will be performed.}

\item{seed_weight}{A numeric value indicating the weight assigned to the seeded terms in the LDA model. This parameter influences how strongly the predefined seed topics affect the topic modeling.}

\item{nr_topics}{An integer specifying the number of topics to be modeled by the LDA algorithm.}

\item{set_seed}{A numeric value setting the seed for the topic modeling algorithm. Default set to 1234.}

\item{lda_seed}{A numeric seed to be set for Gibbs Sampling. Default set to 1000.}

\item{lda_alpha}{A numeric value that set the initial value for alpha.}

\item{lda_best}{If TRUE only the model with the maximum (posterior) likelihood is returned, by default equals TRUE.}

\item{lda_burnin}{A number of omitted Gibbs iterations at beginning, by default equals 0.}

\item{lda_verbose}{A numeric value. If a positive integer, then the progress is reported every verbose iterations. If 0 (default), no output is generated during model fitting.}

\item{lda_iter}{Number of Gibbs iterations (after omitting the burnin iterations), by default equals 2000.}

\item{lda_thin}{Number of omitted in-between Gibbs iterations, by default equals iter.}
}
\value{
A topicmodels LDA object containing the result of the topic modeling. This object includes the topic distribution for each document and the terms associated with each topic.
}
\description{
This function performs topic modeling on word count data using Latent Dirichlet Allocation (LDA). It supports both standard LDA and seeded LDA, where predefined topics can guide the topic modeling process.
}
\details{
The \code{topic_modeling} function performs topic modeling using Latent Dirichlet Allocation (LDA) on a document-term matrix (DTM). If \code{seeded_topics} is provided, a seeded LDA approach is used where predefined topics help guide the model's generation of topics. The function supports:
\itemize{
\item \strong{Standard LDA}: Uses the traditional Gibbs sampling approach to estimate topics from word counts.
\item \strong{Seeded LDA}: Incorporates predefined seed terms into the LDA model by assigning a weight (\code{seed_weight}) to these terms.
}

The function uses the \code{topicmodels} package for LDA and the \code{slam} package to manipulate sparse matrices. The results are captured in an LDA model object, which contains topic-word distributions and document-topic assignments.
}
