% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvef.ph.R
\name{tvef.zero}
\alias{tvef.zero}
\title{testing the significance of the covariates from a \code{coxtv} or \code{coxtp} object}
\usage{
tvef.zero(fit, parm)
}
\arguments{
\item{fit}{fitted \code{coxtv} or \code{coxtp}  model.}

\item{parm}{the names of parameters to be tested.}
}
\value{
\code{tvef.zero} produces a matrix. Each row corresponds to a covariate from the fitted object. The three
columns give the test statistic, degrees of freedom and P-value.
}
\description{
Testing the significance of the covariates from a \code{coxtv} or \code{coxtp} object using a Wald test statistic.
The null hypothesis \eqn{H_0: \beta(t) = 0} for any \eqn{t}, where  \eqn{t} denotes the event time.
}
\examples{
data(ExampleData)
z <- ExampleData$z
time <- ExampleData$time
event <- ExampleData$event
fit <- coxtv(event = event, z = z, time = time)
tvef.ph(fit)

}
\seealso{
\code{\link{tvef.ph}} \code{\link{tvef.zero.time}}
}
