% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c_index.R
\name{cindex_calc}
\alias{cindex_calc}
\title{Calculate Harrell's C-index with 95\% CI}
\usage{
cindex_calc(model, newdata = NULL, digits = 3)
}
\arguments{
\item{model}{a 'coxph' object}

\item{newdata}{optional validation dataset}

\item{digits}{number of decimal places for rounding (default 3).}
}
\value{
numeric vector of C-index (lower, upper)
}
\description{
Calculate Harrell's C-index with 95\% CI
}
\examples{
library(survival)
fit <- coxph(Surv(time, status) ~ age + sex, data = lung)
cindex_calc(fit)



}
