\name{calcHR}
\alias{calcHR}
\title{Computation of log hazard ratio estimate and its standard error estimate from dichotomized data}
\usage{
calcHR(d1,n1,d0,n0)
}
\arguments{
\item{d1}{The number of events in arm 1.}
\item{n1}{The number of sample size in arm 1.}
\item{d0}{The number of events in arm 2.}
\item{n0}{The number of sample size in arm 2.}
}
\value{
\itemize{
\item \code{TE}: The log hazard ratio estimate.
\item \code{seTE}: Standard error estimate for the log hazard ratio.
}
}
\description{
Log hazard ratio estimate and its standard error estimate are calculated from dichotomized data.
}

\references{
Noma, H. and Maruo, K. (2025). Network meta-analysis combining survival and count outcome data: A simple frequentist approach. medRxiv: 10.1101/2025.01.23.25321051.

Salika, T., Turner, R. M., Fisher, D., Tierney, J. F. and White, I. R. (2022). Implications of analysing time-to-event outcomes as binary in meta-analysis: empirical evidence from the Cochrane Database of Systematic Reviews. \emph{BMC Medical Research Methodology} \strong{22}, 73.
}

\examples{
calcHR(1,229,1,227)

calcHR(4,374,7,361)
calcHR(3,372,7,361)
calcHR(2,358,7,361)
}
