% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{brier}
\alias{brier}
\title{Brier Score for Right-Censored Survival Data at a Fixed Time}
\usage{
brier(object, pre_sp, t_star)
}
\arguments{
\item{object}{A `Surv` object with observed time and status.}

\item{pre_sp}{A numeric vector of predicted survival probabilities at `t_star`.}

\item{t_star}{The evaluation time point.}
}
\value{
A single numeric value representing the Brier score a a specific time point.
}
\description{
Computes the Brier score at a fixed time point using inverse probability of censoring weights (IPCW).
}
\examples{
\donttest{
library(survival)
data(veteran, package = "survival")
mod <- survdnn(Surv(time, status) ~
age + karno + celltype, data = veteran, epochs = 50, verbose = FALSE)
pred <- predict(mod, newdata = veteran, type = "survival", times = c(30, 90, 180))
y <- model.response(model.frame(mod$formula, veteran))
survdnn::brier(y, pre_sp = pred[["t=90"]], t_star = 90)
}
}
