% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waning.R
\name{Survmspline_wane}
\alias{Survmspline_wane}
\alias{psurvmspline_wane}
\alias{Hsurvmspline_wane}
\alias{hsurvmspline_wane}
\alias{dsurvmspline_wane}
\alias{qsurvmspline_wane}
\alias{rsurvmspline_wane}
\alias{rmst_survmspline_wane}
\alias{mean_survmspline_wane}
\title{M-spline survival distribution under treatment effect waning}
\usage{
Hsurvmspline_wane(
  x,
  alpha1,
  alpha0,
  coefs1,
  coefs0,
  knots,
  degree = 3,
  wane_period,
  wane_nt = 10,
  pcure1 = 0,
  pcure0 = 0,
  offsetH = 0,
  backhaz = NULL,
  bsmooth = TRUE,
  log = FALSE
)

psurvmspline_wane(
  q,
  alpha1,
  alpha0,
  coefs1,
  coefs0,
  knots,
  degree = 3,
  bsmooth = TRUE,
  wane_period,
  wane_nt = 10,
  lower.tail = TRUE,
  pcure1 = 0,
  pcure0 = 0,
  offsetH = 0,
  backhaz = NULL,
  log.p = FALSE
)

hsurvmspline_wane(
  x,
  alpha1,
  alpha0,
  coefs1,
  coefs0,
  knots,
  degree = 3,
  bsmooth = TRUE,
  wane_period,
  wane_nt = 10,
  pcure1 = 0,
  pcure0 = 0,
  offseth = 0,
  backhaz = NULL,
  log = FALSE
)

dsurvmspline_wane(
  x,
  alpha1,
  alpha0,
  coefs1,
  coefs0,
  knots,
  degree = 3,
  bsmooth = TRUE,
  wane_period,
  wane_nt = 10,
  pcure1 = 0,
  pcure0 = 0,
  offseth = 0,
  offsetH = 0,
  backhaz = NULL,
  log = FALSE
)

qsurvmspline_wane(
  p,
  alpha1,
  alpha0,
  coefs1,
  coefs0,
  knots,
  degree = 3,
  bsmooth = TRUE,
  lower.tail = TRUE,
  log.p = FALSE,
  pcure1 = 0,
  pcure0 = 0,
  offsetH = 0,
  backhaz = NULL,
  wane_period,
  wane_nt = 10
)

rsurvmspline_wane(
  n,
  alpha1,
  alpha0,
  coefs1,
  coefs0,
  knots,
  degree = 3,
  bsmooth = TRUE,
  pcure1 = 0,
  pcure0 = 0,
  offsetH = 0,
  backhaz = NULL,
  wane_period,
  wane_nt = 10
)

rmst_survmspline_wane(
  t,
  alpha1,
  alpha0,
  coefs1,
  coefs0,
  knots,
  degree = 3,
  pcure1 = 0,
  pcure0 = 0,
  offsetH = 0,
  backhaz = NULL,
  bsmooth = TRUE,
  wane_period,
  wane_nt = 10,
  disc_rate = 0,
  method = "gl",
  gl_nodes = 100
)

mean_survmspline_wane(
  alpha1,
  alpha0,
  coefs1,
  coefs0,
  knots,
  degree = 3,
  pcure1 = 0,
  pcure0 = 0,
  backhaz = NULL,
  bsmooth = TRUE,
  wane_period,
  wane_nt = 10,
  disc_rate = 0
)
}
\arguments{
\item{x, q, t}{Vector of times.}

\item{alpha1, coefs1, pcure1}{log hazard intercept, spline coefficients and cure probability before the start of the waning period ("treated")}

\item{alpha0, coefs0, pcure0}{log hazard intercept, spline coefficients and cure probability after the end of the waning period ("untreated")}

\item{knots}{Locations of knots on the axis of time, supplied in
increasing order.  These include the two boundary knots.

In vectorised usage of these functions, the knots and degree must be
the same for all alternative times and parameter values.}

\item{degree}{Spline polynomial degree.  Can only be changed from
the default of 3 if \code{bsmooth} is \code{FALSE}.}

\item{wane_period}{vector of two components giving start and stop of waning
period}

\item{wane_nt}{time resolution for piecewise constant hazard approximation in the
waning period.  If this is not specified, defaults to dividing the waning period into 10 pieces.}

\item{offsetH}{Constant to be added to the cumulative hazard.}

\item{backhaz}{A data frame that defines the background hazard as a piecewise-constant function of time.
This should have two columns, named \code{"time"} and
\code{"hazard"}. Each row gives the "background" hazard between the
specified time and the next time. The first element of
\code{"time"} should be 0, and the final row specifies the hazard at all
times greater than the last element of \code{"time"}.}

\item{bsmooth}{If \code{TRUE} then the function is constrained to
also have zero derivative and second derivative at the boundary.}

\item{log, log.p}{Return log density or probability.}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are \eqn{P(X
\le x)}{P(X <= x)}, otherwise, \eqn{P(X > x)}{P(X > x)}.}

\item{offseth}{Constant to be added to the hazard, e.g. representing a "background" risk of death from causes other than the cause of interest.}

\item{p}{Vector of probabilities.}

\item{n}{Number of random numbers to simulate.}

\item{disc_rate}{Discounting rate used to calculate the discounted mean
or restricted mean survival time, using an exponential discounting function.}

\item{method}{Method of numerical integration to obtain the
restricted mean survival time from the survival function.

The default is \code{method="gl"}, a Gauss-Legendre method with 100
nodes between zero and the maximum of \code{t}.

\code{method="adaptive"} uses the base R \code{integrate} function, which is
much slower, but potentially more robust for badly-behaved
survival functions.}

\item{gl_nodes}{Number of nodes for the Gauss-Legendre method.}
}
\value{
\code{psurvmspline_wane} gives the CDF, \code{Hsurvmspline_wane} gives the cumulative
hazard, \code{hsurvmspline_wane} gives the hazard, \code{dsurvmspline_wane} gives the PDF,
\code{qsurvmspline_wane} gives the quantiles, and \code{rsurvmspline_wane} generates random
numbers from the distribution.
}
\description{
This defines the CDF, cumulative hazard and hazard of a survival
distribution defined by combining the hazards of two different
groups (e.g. "treated" and "untreated") each defined by a standard
M-spline model. The log hazards of one group and the other are
interpolated over a defined period of time.  This may be used for
models where the treatment effect wanes, over a period of time,
between an estimated hazard ratio and zero.
}
\details{
This distribution is defined as follows.
\itemize{
\item Between time 0 and \code{wane_period[1]}, the "treated" hazard is
used, as defined by an M-spline with intercept \code{alpha1}.
\item Between \code{wane_period[1]} and \code{wane_period[2]}, the log hazard is
defined by linear interpolation.  The waning period is divided
into a number of discrete pieces in which the hazard is assumed to
be constant, defined by the hazard at the start of the piece.
These hazard values are obtained from the spline model, using an
intercept parameter \code{alpha} (log scale parameter) defined by
linearly interpolating between \code{alpha1} and \code{alpha0} over the
waning period.  The cumulative hazard at any time can then be
deduced by adding up contributions on each piece.
\item After \code{wane_period[2]}, the "untreated" hazard is used, as defined by an
M-spline with intercept \code{alpha0}.
}

See the \href{https://chjackson.github.io/survextrap/articles/methods.html}{methods vignette} for more details and examples.

This can be used to predict the hazard of a person treated with a
treatment whose short-term effect is estimated from shorter-term
data, but we wish to extrapolate this model over a longer period
where the effect is assumed to diminish.

This may not work if the hazard is zero or infinite at any point
in the waning period (thus the log hazard is indeterminate).  This
might typically happen at time 0.
}
\keyword{distribution}
