% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspline_init.R
\name{mspline_list_init}
\alias{mspline_list_init}
\title{Validate an M-spline object supplied as a list, choosing defaults
if needed.}
\usage{
mspline_list_init(mspline, obstimes = NULL)
}
\arguments{
\item{mspline}{A list with any or none of the following components:
\code{df}, \code{degree}, \code{bsmooth}, \code{knots}, \code{bknot},
as documented in \code{\link{mspline_init}}.}

\item{obstimes}{Vector of observation times whose quantiles will be
used to choose knot locations}
}
\value{
A list defining the M-spline, with any omitted list components set
to defaults.  See \code{\link{mspline_init}} for details.

If \code{mspline$knots} is not supplied, giving knot locations, then
either \code{mspline$bknot} or \code{obstimes} must be specified,
so that default locations can be obtained.
}
\description{
Validate an M-spline object supplied as a list, choosing defaults
if needed.
}
