% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singlechoice.R
\name{single_table}
\alias{single_table}
\title{Create a table of frequencies and counts for single-choice questions}
\usage{
single_table(
  dataset,
  question,
  group_by = NULL,
  subgroups_to_exclude = NULL,
  weights = NULL,
  na.rm = FALSE
)
}
\arguments{
\item{dataset}{The input dataframe (or tibble) of survey questions}

\item{question}{The categorical variable of interest for which frequencies
and counts will be calculated, can be selected by using \strong{tidyselect}
semantics}

\item{group_by}{Optional variable to group the analysis. If provided, the
frequencies and counts will be calculated within each subgroup.}

\item{subgroups_to_exclude}{Optional vector specifying subgroups to exclude
from the analysis.}

\item{weights}{Optional variable containing survey weights. If provided,
frequencies and counts will be weighted accordingly.}

\item{na.rm}{Logical indicating whether to remove NA values from \code{question}
before analysis.}
}
\value{
A gt table summarizing frequencies and counts based on the specified
parameters. If the optional \code{group_by} parameter is provided, the output
will be a grouped gt table, displaying frequencies and counts for each
subgroup as well as row and column totals.
}
\description{
Generates a detailed table summarizing the frequencies and counts for each level
of the specified variable, \code{question}. If a grouping variable, \code{group_by}, is provided,
the table extends to include row and column totals, along with additional count and
frequency columns for each level of \code{group_by} (excluding specified subgroups, if any).
When survey weights are specified with \code{weights}, the counts reflect the weighted values,
and a note is appended at the bottom of the table.
}
\examples{
#Simple table
single_table(berlinbears, question = income)

#Use `group_by` to partition the question into several groups
single_table(berlinbears, question = income, group_by = gender)

#to ignore a subgroup, use `subgroups_to_exclude`
single_table(berlinbears, question = income, group_by = species,
subgroups_to_exclude = c('black bear', NA))

#Specifiy survey weights with `weights`
 single_table(berlinbears, question = h_winter, group_by = gender,
 weights = weights)

#to ignore NA values in the responses to `question`, set na.rm = TRUE
single_table(berlinbears, question = h_winter, na.rm = TRUE)


}
\seealso{
Other single-choice questions: 
\code{\link{single_freq}()},
\code{\link{single_summary}()}
}
\concept{single-choice questions}
