% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make-projection.R
\name{make_projection}
\alias{make_projection}
\title{Outputs the survey projection onto the agent or symbolic layer}
\usage{
make_projection(
  data,
  layer = NULL,
  method = NULL,
  methodval = NULL,
  comparisons = NULL,
  metric = NULL,
  limits = NULL,
  dummycode = NULL,
  bootreps = NULL,
  bootval = NULL,
  bootseed = NULL,
  centre = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame corresponding to a survey}

\item{layer}{A string flag specifying which layer to project
\itemize{
\item \code{"agent"} produces the network corresponding to the agents, which we assume
to be rows in \code{data}
\item \code{"symbolic"} produces the network corresponding to the symbols, or items,
which we assume to be columns in \code{data}
}}

\item{method}{A string flag specifying how edges are thresholded in
the network representation.
\itemize{
\item \code{"similarity"} means we remove all edges whose weight, meaning node
similarity, is below a threshold specified by \code{methodval}.
\item \code{"lcc"} finds the value of the threshold that results in the network
whose largest connected component is as close as possible to a specified
value. In general a range of thresholds will satisfy this condition, and we
choose the upper limit of this range. As such, \code{"lcc"} provided is a target.
\item \code{"avgdegree"} finds the value of the threshold that results in the network
whose average degree is as close as possible to a specified value. Like
\code{"lcc"}, this is a target.
}}

\item{methodval}{A utility variable that we interpret according to the
\code{method} chosen.
\itemize{
\item If \code{method = "similarity"}, then \code{methodval} is
interpreted as the similarity threshold, and thus is in the range \verb{[0, 1]}.
A value of 0 means no edges are removed, and a value of 1 means all edges
are removed.
\item If \code{method = "lcc"}, then \code{methodval} is interpreted as
the desired fractional size of the largest connected component, in the range
\verb{[0, 1]}. E.g., when set to 0, no nodes are connected, and if set to 1, the
network is as sparse as possible while remaining fully connected.
\item If \code{method = "avgdegree"}, then \code{methodval} is interpreted as
the desired average degree. We assume that \code{methodval} is normalised to
the range \verb{[0, 1]} When \code{method_value = 0}, then no nodes are connected, and
if \code{method_value = 1}, the network is complete, meaning it contains every
possible edge.
}}

\item{comparisons}{The minimum number of valid comparisons that must be
made when computing the similarity between rows or columns in the \code{data}. If at
least one of the entries in the fields being compared is NA, then the
comparison is invalid.}

\item{metric}{This currently has just one allowed value, namely the
Manhattan distance, which is the default.}

\item{limits}{Specifies the limits of the Likert scale contained in \code{data}.}

\item{dummycode}{flag that indicates whether we dummycode data.}

\item{bootreps}{The number of bootstrap realisations to perform. If not
specified, bootstrapping is not carried out.}

\item{bootval}{A sampling probability used when bootstraping. In particular,
it provides the probability of sampling a given survey entry in a given
bootstrapping step. With probability 1 - bootval, that entry is set to NA.}

\item{bootseed}{A random number generator seed used when bootstrapping.
Mainly used for testing, but maybe useful for reproducibility in general.}

\item{centre}{If \code{TRUE}, we shift edge weights from \verb{[0, 1]} to \verb{[-1, 1]}.
Defaults to FALSE, as most network analysis applications require positive
edge weights.}

\item{...}{Mostly used to handle deprecated arguments, and arguments with
alternative spellings.}
}
\value{
A data frame corresponding to the edge list of the specified network. It
contains three columns named
\itemize{
\item \code{u}, the first node adjacent to the edge
\item \code{v}, the second node adjacent to the edge, and
\item \code{weight}, the similarity between nodes \code{u} and \code{v}
}
}
\description{
\code{make_projection()} outputs the agent or symbolic network corresponding
to a survey, i.e. the row or column projection.
}
\examples{
S <- make_synthetic_data(20, 5)
}
