% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sresult.R
\name{sresult}
\alias{sresult}
\title{Summary for Svensson's Method}
\usage{
sresult(t)
}
\arguments{
\item{t}{The contingency table for Svensson's method, a two-dimension matrix.}
}
\value{
\code{sresult} lists the results for Svensson's method. PA for percentage agreement,
RP for relative position, RC for relative concentration, RV for relative rank variance,
SE(RP), SE(RC), SE(RV) for the corresponding standard error and CI(RP), CI(RC),  CI(RV) for
the 95\% confidence interval. IV for internal rank variance, R.Alpha for augmented correlation
coefficient, P.R.Alpha for the corresponding p-value (significant level 0.05).
}
\description{
List all the results for Svensson's Method. Including percentage agreement, systematic change
and individual change.
}
\examples{
x <- c (1:5,5:1)
y <- c(1:5,1,1,5,4,1)
z <- con_ta(x,y,)
sresult(z)
}
\seealso{
\code{\link{con_ta}} for generating contingency table.
}
